/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IFlowerModelProvider;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerPotHandler {
    private static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> FULL_POTS;
    private static final List<BlockState> FULL_POT_LIST;
    private static final Map<Item, ResourceLocation> SPECIAL_FLOWER_BOX_FLOWERS;
    private static final List<ResourceLocation> CUSTOM_MODELS;

    public static BlockState getAprilPot() {
        int ind = (int)(System.currentTimeMillis() / 15000L % (long)FULL_POT_LIST.size());
        return FULL_POT_LIST.get(ind);
    }

    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        return FULL_POTS.get(emptyPot.getEmptyPot()).getOrDefault(flowerBlock.getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get();
    }

    public static boolean isEmptyPot(Block b) {
        return FULL_POTS != null && b != null && FULL_POTS.containsKey(b);
    }

    public static void init() {
        HashSet<FlowerPotBlock> emptyPots = new HashSet<FlowerPotBlock>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof FlowerPotBlock)) continue;
            emptyPots.add(((FlowerPotBlock)b).getEmptyPot());
        }
        FULL_POTS = Maps.newHashMap();
        for (FlowerPotBlock pot : emptyPots) {
            try {
                Field f = ObfuscationReflectionHelper.findField(FlowerPotBlock.class, (String)"fullPots");
                f.setAccessible(true);
                FULL_POTS.put((Block)pot, (Map)f.get(pot));
                FULL_POT_LIST.addAll(((Map)f.get(pot)).values().stream().map(s -> ((Block)s.get()).func_176223_P()).collect(Collectors.toList()));
            }
            catch (Exception ignored) {
                Supplementaries.LOGGER.info("Failed to create flower pots");
            }
        }
    }

    public static void registerCustomFlower(Item item2, ResourceLocation model) {
        SPECIAL_FLOWER_BOX_FLOWERS.put(item2, model);
    }

    private static void registerCompatFlower(String itemRes) {
        Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRes));
        if (item2 != null && item2 != Items.field_190931_a) {
            ResourceLocation res = Supplementaries.res("plants/" + item2.getRegistryName().func_110623_a());
            CUSTOM_MODELS.add(res);
            FlowerPotHandler.registerCustomFlower(item2, res);
        }
    }

    public static void registerCustomModels(Consumer<String> registerFunction) {
        CUSTOM_MODELS.stream().map(ResourceLocation::toString).forEach(registerFunction);
    }

    @Nullable
    public static ResourceLocation getSpecialFlowerModel(Item i) {
        ResourceLocation res = SPECIAL_FLOWER_BOX_FLOWERS.get(i);
        if (res != null) {
            return res;
        }
        if (i instanceof IFlowerModelProvider) {
            return ((IFlowerModelProvider)i).getModel();
        }
        if (i instanceof BlockItem && ((BlockItem)i).func_179223_d() instanceof IFlowerModelProvider) {
            return ((IFlowerModelProvider)((BlockItem)i).func_179223_d()).getModel();
        }
        return null;
    }

    public static boolean hasSpecialFlowerModel(Item i) {
        return FlowerPotHandler.getSpecialFlowerModel(i) != null;
    }

    static {
        FULL_POT_LIST = new ArrayList<BlockState>();
        SPECIAL_FLOWER_BOX_FLOWERS = new HashMap<Item, ResourceLocation>();
        CUSTOM_MODELS = new ArrayList<ResourceLocation>();
        ArrayList<String> toAdd = new ArrayList<String>();
        toAdd.add(Items.field_221774_cw.getRegistryName().toString());
        toAdd.add(((Item)ModRegistry.FLAX_SEEDS_ITEM.get()).getRegistryName().toString());
        if (CompatHandler.quark) {
            Item[] items2 = new Item[]{Items.field_222065_kN, Items.field_185163_cU, Items.field_151172_bF, Items.field_221663_bT, Items.field_151174_bG, Items.field_221674_ay, Items.field_196130_bo, Items.field_151014_N, Items.field_221796_dh, Items.field_221918_fq, Items.field_222112_pR, Items.field_234718_bB_, Items.field_234717_bA_, Items.field_151081_bc, Items.field_151080_bb, Items.field_221916_fp, Items.field_221601_aC, Items.field_151075_bm};
            toAdd.add("quark:chorus_weeds");
            toAdd.add("quark:root");
            toAdd.add("quark:chorus_twist");
            Arrays.stream(items2).forEach(i -> toAdd.add(i.getRegistryName().toString()));
        }
        if (CompatHandler.pokecube_legends) {
            toAdd.add("pokecube_legends:crystallized_cactus");
        }
        if (CompatHandler.pokecube) {
            String[] berries = new String[]{"pokecube:berry_aspear", "pokecube:berry_cheri", "pokecube:berry_chesto", "pokecube:berry_cornn", "pokecube:berry_enigma", "pokecube:berry_grepa", "pokecube:berry_hondew", "pokecube:berry_jaboca", "pokecube:berry_kelpsy", "pokecube:berry_leppa", "pokecube:berry_lum", "pokecube:berry_nanab", "pokecube:berry_null", "pokecube:berry_oran", "pokecube:berry_pecha", "pokecube:berry_persim", "pokecube:berry_pinap", "pokecube:berry_pomeg", "pokecube:berry_qualot", "pokecube:berry_rawst", "pokecube:berry_rowap", "pokecube:berry_sitrus", "pokecube:berry_tamato"};
            toAdd.addAll(Arrays.asList(berries));
        }
        if (CompatHandler.moreminecarts) {
            toAdd.add("moreminecarts:chunkrodite_block");
            toAdd.add("moreminecarts:glass_cactus");
        }
        if (CompatHandler.habitat) {
            toAdd.add("habitat:rafflesia");
            toAdd.add("habitat:orange_ball_cactus");
            toAdd.add("habitat:red_ball_cactus");
            toAdd.add("habitat:pink_ball_cactus");
            toAdd.add("habitat:yellow_ball_cactus");
            toAdd.add("habitat:kabloom_pulp");
        }
        if (CompatHandler.endergetic) {
            toAdd.add("endergetic:tall_poise_bush");
        }
        if (CompatHandler.simplefarming) {
            toAdd.add("simplefarming:cantaloupe_block");
            toAdd.add("simplefarming:honeydew_block");
            toAdd.add("simplefarming:squash_block");
        }
        if (CompatHandler.atmospheric) {
            toAdd.add("atmospheric:barrel_cactus");
        }
        toAdd.forEach(FlowerPotHandler::registerCompatFlower);
    }
}

